<?php
/**
 * @package web-prediksi
 * @since 1.0.0
 */

define( 'EXCPATH', dirname( __FILE__ ) );
define( 'TXTDOMAIN', 'web-prediksi' );

require_once get_stylesheet_directory() . '/classes/class-bootstrap-navwalker.php';
require_once get_stylesheet_directory() . '/classes/class-simple-html-dom.php';
require_once get_stylesheet_directory() . '/classes/class-exito-post.php';
require_once get_stylesheet_directory() . '/classes/class-exito-system.php';
require_once get_stylesheet_directory() . '/classes/class-exito.php';
require_once get_stylesheet_directory() . '/includes/include-custom.php';
require_once get_stylesheet_directory() . '/includes/include-paito.php';
require_once get_stylesheet_directory() . '/includes/include-rtpslot.php';

global $exito;
$exito = new Exito();
$exito->run();

function web_logo( $class = null ) {
    global $exito;
    return $exito->web_logo( $class );
}

function web_copyright( $date = '2000' ) {
    return __( 'Copyright', TXTDOMAIN ) . ' &copy; ' . $date . ' - ' . date( 'Y' ) . ' <a class="site-url" href="/">' . get_bloginfo( 'name' ) . '</a>, All Rights Reserved.';
}

function format_prize($data = [], $load = '') {
    if (isset($data['tanggal'])) {
        $data['tanggal'] = ( $data['tanggal'] == '' ) ? date( 'd M Y' ) : $data['tanggal'];
    }
    if (isset($data['prize_1'])) {
        $data['prize_1'] = is_numeric($data['prize_1']) ? $data['prize_1'] : $load;
    }
    if (isset($data['prize_2'])) {
        $data['prize_2'] = is_numeric($data['prize_2']) ? $data['prize_2'] : $load;
    }
    if (isset($data['prize_3'])) {
        $data['prize_3'] = is_numeric($data['prize_3']) ? $data['prize_3'] : $load;
    }

    if (isset($data['prize_4'])) {
        if (is_array($data['prize_4'])) :
            foreach ($data['prize_4'] as $key4 => $val4) {
                $data['prize_4'][$key4] = (is_numeric($val4) ? $val4 : $load);
            }
        else :
            $data['prize_4'] = is_numeric($data['prize_4']) ? $data['prize_4'] : $load;
        endif;
    }
    if (isset($data['prize_5'])) {
        if (is_array($data['prize_5'])) :
            foreach ($data['prize_5'] as $key5 => $val5) {
                $data['prize_5'][$key5] = (is_numeric($val5) ? $val5 : $load);
            }
        else :
            $data['prize_5'] = is_numeric($data['prize_5']) ? $data['prize_5'] : $load;
        endif;
    }
    if (isset($data['prize_6'])) {
        if (is_array($data['prize_6'])) :
            foreach ($data['prize_6'] as $key6 => $val6) {
                $data['prize_6'][$key6] = (is_numeric($val6) ? $val6 : $load);
            }
        else :
            $data['prize_6'] = is_numeric($data['prize_6']) ? $data['prize_6'] : $load;
        endif;
    }
    if (isset($data['prize_7'])) {
        if (is_array($data['prize_7'])) :
            foreach ($data['prize_7'] as $key7 => $val7) {
                $data['prize_7'][$key7] = (is_numeric($val7) ? $val7 : $load);
            }
        else :
            $data['prize_7'] = is_numeric($data['prize_7']) ? $data['prize_7'] : $load;
        endif;
    }

    return $data;
}

function sc_tanggal() {
    return date_i18n( 'd F Y', strtotime( '+1days' ) );
}
add_shortcode('tanggal', 'sc_tanggal');

function sc_banner() {
    $html = '';
    if (is_active_sidebar('prediksi_banner')) :
        ob_start();
        dynamic_sidebar('prediksi_banner');
        $banner = ob_get_contents();
        ob_get_clean();

        $html .= '<div class="content-banner my-3">';
        $html .= '    <div class="row no-gutters">';
        $html .= '        <div class="col-12">' . $banner . '</div>';
        $html .= '    </div>';
        $html .= '</div>';
    endif;
    return $html;
}
add_shortcode('banner', 'sc_banner');

function sc_data_result() {
    ob_start();
    
    get_template_part( 'components/part-card', 'data-result' );

    $output = ob_get_contents();

    ob_get_clean();

    return $output;
}
add_shortcode('data_result', 'sc_data_result');

function sc_livedraw() {
    ob_start();
    
    get_template_part( 'components/part-card', 'livedraw' );

    $output = ob_get_contents();

    ob_get_clean();

    return $output;
}
add_shortcode('livedraw', 'sc_livedraw');

function sc_paito() {
    ob_start();
    
    get_template_part( 'components/part-card', 'paito' );

    $output = ob_get_contents();

    ob_get_clean();

    return $output;
}
add_shortcode('paito', 'sc_paito');

function sc_promo( $atts, $content = null ) {
    $html  = '<div class="promo-wrapper">';
    $html .= do_shortcode( $content );
    $html .= '</div>';

    return $html;
}
add_shortcode('promo', 'sc_promo');

function sc_promo_gambar( $atts, $content = null ) {
    $data = shortcode_atts( [ 'id' => 1 ], $atts );
    
    $html  = '';
    $html .= '<div class="promo-head collapsed" href="#promo-item-' . $data['id'] . '" data-toggle="collapse" aria-expanded="false" aria-controls="#promo-item-' . $data['id'] . '" style="cursor: pointer;">';
    $html .= $content;
    $html .= '<h5 class="text-center my-2" style="color: #f1c40f;">↑ Klik Gambar untuk info lebih lanjut ↑</h5>';
    $html .= '</div>';

    return $html;
}
add_shortcode('promo_gambar', 'sc_promo_gambar');

function sc_promo_content( $atts, $content = null ) {
    $data = shortcode_atts( [ 'id' => 1 ], $atts );
    
    $html  = '';
    $html .= '<div class="promo-body collapse" id="promo-item-' . $data['id'] . '">' . $content . '</div>';

    return $html;
}
add_shortcode('promo_content', 'sc_promo_content');
