<?php
/**
 * @package web-prediksi
 * @since 1.0.0
 */

$code = 'p48601';

// scrape livedraw
function scrape_livedraw() {
    ini_set("user_agent", "Mozilla/5.0 (Windows NT 6.1; rv:8.0) Gecko/20100101 Firefox/8.0");

    date_default_timezone_set( get_option( 'timezone_string' ) );
    
    $html = file_get_html('https://livedraw.news/livejapan.html');
    $load = '<img src="https://bit.ly/3cfQ3ez" style="width: 18px !important; height: 18px !important;">';
    $data = [
        'tanggal' => '',
        'prize_1' => '',
        'prize_2' => '',
        'prize_3' => '',
        'prize_4' => [ 1 => '', 2 => '', 3 => '', 4 => '', 5 => '', 6 => '' ],
        'prize_6' => [ 1 => '', 2 => '', 3 => '', 4 => '', 5 => '', 6 => '' ],
    ];

    $data['tanggal'] = trim($html->find('td[class="box-color sgp"]', 0)->find('span', 1)->plaintext);
    $data['prize_1'] = trim(preg_replace('/\s+/', '', $html->find('td[class="box-value"]', 0)->plaintext));
    $data['prize_2'] = trim(preg_replace('/\s+/', '', $html->find('td[class="box-value"]', 1)->plaintext));
    $data['prize_3'] = trim(preg_replace('/\s+/', '', $html->find('td[class="box-value"]', 2)->plaintext));
    $data['prize_4'] = [
        1 => trim(preg_replace('/\s+/', '', $html->find('td[class="box-value"]', 3)->plaintext)),
        2 => trim(preg_replace('/\s+/', '', $html->find('td[class="box-value"]', 5)->plaintext)),
        3 => trim(preg_replace('/\s+/', '', $html->find('td[class="box-value"]', 7)->plaintext)),
        4 => trim(preg_replace('/\s+/', '', $html->find('td[class="box-value"]', 9)->plaintext)),
        5 => trim(preg_replace('/\s+/', '', $html->find('td[class="box-value"]', 11)->plaintext)),
        6 => trim(preg_replace('/\s+/', '', $html->find('td[class="box-value"]', 13)->plaintext)),
    ];
    $data['prize_6'] = [
        1 => trim(preg_replace('/\s+/', '', $html->find('td[class="box-value"]', 4)->plaintext)),
        2 => trim(preg_replace('/\s+/', '', $html->find('td[class="box-value"]', 6)->plaintext)),
        3 => trim(preg_replace('/\s+/', '', $html->find('td[class="box-value"]', 8)->plaintext)),
        4 => trim(preg_replace('/\s+/', '', $html->find('td[class="box-value"]', 10)->plaintext)),
        5 => trim(preg_replace('/\s+/', '', $html->find('td[class="box-value"]', 12)->plaintext)),
        6 => trim(preg_replace('/\s+/', '', $html->find('td[class="box-value"]', 14)->plaintext)),
    ];

    return format_prize($data, $load);
}
