<?php
/**
 * @package web-prediksi
 * @since 1.0.0
 */

function rtp_providers() {
    return [
        'idn' => [ 'idgm' => '13',  'code' => 'IDN',    'name' => 'IDN Slot' ],
        'pp'  => [ 'idgm' => '5',   'code' => 'PP',     'name' => 'Pragmatic Play' ],
        'pg'  => [ 'idgm' => '92',  'code' => 'PGSoft', 'name' => 'PG Soft' ],
        'mg'  => [ 'idgm' => '97',  'code' => 'MG',     'name' => 'Microgaming' ],
        'hb'  => [ 'idgm' => '12',  'code' => 'HB',     'name' => 'Habanero' ],
        'ttg' => [ 'idgm' => 'ttg', 'code' => 'TTG',    'name' => 'Top Trend' ],
        'gmw' => [ 'idgm' => '107', 'code' => 'GMW',    'name' => 'GMW' ],
    ];
}

function rtp_games( $provider = [] ) {
    if ( file_exists( get_template_directory() . '/json/' . $provider['code'] . '.json' ) ) {
        $json = file_get_contents( get_template_directory() . '/json/' . $provider['code'] . '.json' );
        $data = json_decode( $json, true );
        return $data;
    }
}

function set_rtp_percent( $date = '', $week = '', $hour = '', $mixs = 1 ) {
    date_default_timezone_set('Asia/Jakarta');

    $time = pow( ($week + $date), $hour );

    if ($mixs > 2500) {
        $math = [ 0 => 27, 1 => 65 ];
    } else {
        $math = [ 0 => 83, 1 => 8 ];
    }

    $numb = fmod( ($time * $mixs), $math[0] ) + $math[1];

    return ( ( $numb < 0 ) ? 12 : $numb );
}

function set_rtp_time( $date, $hour, $percent ) {
    $time  = '';
    $timex = intval( ($percent % 3) + 1 );
    $time1 = intval( ($hour + rand(2, 7)) % 24 );
    $time2 = intval( ($time1 + $timex) % 24 );

    $mins1 = intval( $percent % 60 );
    $mins2 = intval( ($percent * $date) % 60 );

    $time .= ( ($time1 <= 9) ? '0'.$time1 : $time1 ) . ':';
    $time .= ( ($mins1 <= 9) ? '0'.$mins1 : $mins1 ) . ' - ';
    $time .= ( ($time2 <= 9) ? '0'.$time2 : $time2 ) . ':';
    $time .= ( ($mins2 <= 9) ? '0'.$mins2 : $mins2 );

    return $time;
}

function set_rtp_pola( $index = 1, $percent = 0 ) {
    $data_pola = '';
    $pola_icon = ["✔️✖️✖️", "✖️✔️✖️", "✖️✖️✔️", "✔️✖️✔️", "✖️✔️✔️", "✖️✖️✖️"];
    $pola_text = ["Auto", "Auto", "Manual 3", "Manual 5", "Manual 7", "Manual 9", "Auto", "Auto", "Auto", "Auto", "Auto", "Auto"];
    $pola_numb = [10, 20, 50, 70, 100];

    $n1 = $index % 6;
    $p1 = [ ($percent % 4), ($percent % 5), ($percent % 6) ];
    $n2 = $index % 5;
    $p2 = [ ($percent % 4), ($percent % 5), ($percent % 6) ];

    for ($j = 0; $j < 3; $j++) {
        for ($k = 0; $k < 3; $k++) {
            if ($p1[$j] == $p1[$k] && $j != $k) {
                $p1[$k] = ($p1[$k] + 1) % 6;
            }
        }
    }

    $p3 = [ (pow($p1[0], $p2[0]) % 12), (pow($p1[1], $p2[1]) % 12), (pow($p1[2], $p2[2]) % 12) ];

    for ($j = 0; $j < 3; $j++) {
        if ($pola_text[$p3[$j]] == "Auto") {
            $data_pola .= $pola_numb[$p2[$j]]." ".$pola_icon[$p2[$j]]." ".$pola_text[$p3[$j]].( ($j == 3) ? '' : "\n" );
        } else {
            $data_pola .= $pola_text[$p3[$j]]." ".$pola_icon[$p1[$j]].( ($j == 3) ? '' : "\n" );
        }
    }

    return $data_pola;
}

function formatting_rtp( $list = [], $provider = [] ) {
    $_page = get_pages([ 'post_type' => 'page', 'meta_key' => '_wp_page_template', 'meta_value' => 'page-rtpslot.php' ]);
    $_link = get_post_meta( $_page[0]->ID, 'link-rtp-slot', true );

    $date = intval(date('Y')) * intval(date('m')) * intval(date('d'));
    $week = intval(date('w', strtotime(date('Y-m-d')))) + 1;
    $hour = intval(date('H'));

    $html  = '';
    $html .= '<h3 class="text-center text-uppercase font-weight-bold mb-3">' . $provider['name'] . '</h3>';
    $html .= '<div class="row row-cols-lg-6 no-gutters">';

    $numb = 1; $rand = rand( 5, 15);
    foreach ( $list as $game ) :
        $index = ( $numb + $rand );
        $percent = set_rtp_percent( $date, $week, $hour, $game['odds'] );
        $rtppola = set_rtp_pola( $index, $percent );
        $rtptime = set_rtp_time( $date, $hour, $percent );
        $x_class = ( $percent > 70 ) ? 'green' : ( ( $percent < 40 ) ? 'red' : 'yellow' );

        $html .= '<div class="col-4 col-lg d-flex px-1 py-1">';
        $html .= '    <div class="card card-game bg-gradient-2 shadow border-0 px-1 py-1">';
        $html .= '        <div class="card-body border-0 px-0 py-0">';
        $html .= '            <img class="w-100" src="/assets/images/' . $provider['code'] . '/' . $game['image'] .'" alt="' . $game['title'] . '" loading="lazy">';
        $html .= '            <p class="text-description text-center text-uppercase bg-color-2 px-1 mb-0"><small>' . $game['title'] . '</small></p>';
        $html .= '            <div class="play-box bg-color-1 px-2 py-2">';
        $html .= '                <a class="btn btn-play text-white font-weight-bold" href="' . $_link . '">PLAY</a>';
        $html .= '                <a class="btn btn-pola text-white font-weight-bold" data-toggle="modal" data-target="#modal-pola-' . $index . '" href="javascript:void(0);">POLA MAIN</a>';
        $html .= '            </div>';
        $html .= '        </div>';
        $html .= '        <div class="card-footer border-0 px-0 py-0">';
        $html .= '            <div class="percent">';
        $html .= '                <div id="percent-bar-0" class="percent-bar ' . $x_class . '" role="progressbar" aria-valuemin="0" aria-valuemax="100" aria-valuenow="' . $percent . '" style="width: ' . $percent . '%;"></div>';
        $html .= '                <p id="percent-txt-0" style="z-index: 15">' . $percent . '%</p>';
        $html .= '            </div>';
        $html .= '        </div>';
        $html .= '    </div>';
        $html .= formatting_rtp_pola( $index, $rtptime, $rtppola, $percent, $game['title'], '/assets/images/' . $provider['code'] . '/' . $game['image'] );
        $html .= '</div>';

        $numb++;
    endforeach;

    $html .= '</div>';

    return $html;
}

function formatting_rtp_pola( $index = 1, $jam = '', $pola = '', $percent = '', $game_name = '', $game_image = '' ) {
    $html  = '<div id="modal-pola-' . $index . '" class="modal fade" data-backdrop="static" data-keyboard="false">';
    $html .= '    <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">';
    $html .= '        <div class="modal-content border-0">';
    $html .= '            <div class="modal-header bg-gradient-3 border-0 d-flex justify-content-between align-items-center">';
    $html .= '                <h5 class="text-dark text-uppercase modal-title mb-0"><small class="font-weight-bold">' . $game_name . '</small></h5>';
    $html .= '                <button type="button" class="close" data-dismiss="modal" aria-label="Close">';
    $html .= '                    <span aria-hidden="true">&times;</span>';
    $html .= '                </button>';
    $html .= '            </div>';
    $html .= '            <div class="modal-body">';
    $html .= '                <div class="row no-gutters">';
    $html .= '                    <div class="col-12">';
    $html .= '                        <img class="game-image w-100" src="' . $game_image . '" alt="' . $game_name . '">';
    $html .= '                    </div>';
    $html .= '                    <div class="col-12">';
    $html .= '                        <div class="row no-gutters">';
    $html .= '                            <div class="col-12">';
    $html .= '                                <h6 class="text-dark text-center text-uppercase mb-3"><small class="font-weight-bold">RTP dan Pola ' . $game_name . '</small></h6>';
    $html .= '                            </div>';
    $html .= '                            <div class="col-12 pl-lg-3">';
    $html .= '                                <table class="table table-pola table-sm table-borderless table-striped">';
    $html .= '                                    <tr class=""><th width="40%">Jam Panas!</th><td>' . $jam . '</td></tr>';
    $html .= '                                    <tr class=""><th width="40%">Pola Spin</th><td class="pola-content">' . $pola . '</td></tr>';
    $html .= '                                    <tr class=""><th width="40%">RTP Live</th><td>' . $percent . '%</td></tr>';
    $html .= '                                </table>';
    $html .= '                                <button class="btn btn-sm btn-danger ml-auto mr-auto" data-dismiss="modal" aria-label="Tutup"><small>Tutup</small></button>';
    $html .= '                            </div>';
    $html .= '                        </div>';
    $html .= '                    </div>';
    $html .= '                </div>';
    $html .= '            </div>';
    $html .= '        </div>';
    $html .= '    </div>';
    $html .= '</div>';

    return $html;
}
